package org.wildfly.swarm.config.ejb3.service;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * An database based store for persistent EJB timers.
 */
@Address("/subsystem=ejb3/service=timer-service/database-data-store=*")
@ResourceType("database-data-store")
public class DatabaseDataStore<T extends DatabaseDataStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("If this node is allowed to execute timers. If this is false then the timers will be added to the database, and another node may execute them. Note that depending on your refresh interval if you add timers with a very short delay they will not be executed until another node refreshes.")
	private Boolean allowExecution;
	@AttributeDocumentation("The type of database that is in use. SQL can be customised per database type.")
	private String database;
	@AttributeDocumentation("The datasource that is used to persist the timers")
	private String datasourceJndiName;
	@AttributeDocumentation("The partition name. This should be set to a different value for every node that is sharing a database to prevent the same timer being loaded by multiple noded.")
	private String partition;
	@AttributeDocumentation("Interval between refreshing the current timer set against the underlying database. A low value means timers get picked up more quickly, but increase load on the database.")
	private Integer refreshInterval;

	public DatabaseDataStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If this node is allowed to execute timers. If this is false then the
	 * timers will be added to the database, and another node may execute them.
	 * Note that depending on your refresh interval if you add timers with a
	 * very short delay they will not be executed until another node refreshes.
	 */
	@ModelNodeBinding(detypedName = "allow-execution")
	public Boolean allowExecution() {
		return this.allowExecution;
	}

	/**
	 * If this node is allowed to execute timers. If this is false then the
	 * timers will be added to the database, and another node may execute them.
	 * Note that depending on your refresh interval if you add timers with a
	 * very short delay they will not be executed until another node refreshes.
	 */
	@SuppressWarnings("unchecked")
	public T allowExecution(java.lang.Boolean value) {
		Object oldValue = this.allowExecution;
		this.allowExecution = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowExecution", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of database that is in use. SQL can be customised per database
	 * type.
	 */
	@ModelNodeBinding(detypedName = "database")
	public String database() {
		return this.database;
	}

	/**
	 * The type of database that is in use. SQL can be customised per database
	 * type.
	 */
	@SuppressWarnings("unchecked")
	public T database(java.lang.String value) {
		Object oldValue = this.database;
		this.database = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("database", oldValue, value);
		return (T) this;
	}

	/**
	 * The datasource that is used to persist the timers
	 */
	@ModelNodeBinding(detypedName = "datasource-jndi-name")
	public String datasourceJndiName() {
		return this.datasourceJndiName;
	}

	/**
	 * The datasource that is used to persist the timers
	 */
	@SuppressWarnings("unchecked")
	public T datasourceJndiName(java.lang.String value) {
		Object oldValue = this.datasourceJndiName;
		this.datasourceJndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("datasourceJndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * The partition name. This should be set to a different value for every
	 * node that is sharing a database to prevent the same timer being loaded by
	 * multiple noded.
	 */
	@ModelNodeBinding(detypedName = "partition")
	public String partition() {
		return this.partition;
	}

	/**
	 * The partition name. This should be set to a different value for every
	 * node that is sharing a database to prevent the same timer being loaded by
	 * multiple noded.
	 */
	@SuppressWarnings("unchecked")
	public T partition(java.lang.String value) {
		Object oldValue = this.partition;
		this.partition = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("partition", oldValue, value);
		return (T) this;
	}

	/**
	 * Interval between refreshing the current timer set against the underlying
	 * database. A low value means timers get picked up more quickly, but
	 * increase load on the database.
	 */
	@ModelNodeBinding(detypedName = "refresh-interval")
	public Integer refreshInterval() {
		return this.refreshInterval;
	}

	/**
	 * Interval between refreshing the current timer set against the underlying
	 * database. A low value means timers get picked up more quickly, but
	 * increase load on the database.
	 */
	@SuppressWarnings("unchecked")
	public T refreshInterval(java.lang.Integer value) {
		Object oldValue = this.refreshInterval;
		this.refreshInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("refreshInterval", oldValue, value);
		return (T) this;
	}
}