package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AddSuffixRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AddSuffixRoleMapperConsumer<T extends AddSuffixRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of AddSuffixRoleMapper resource
	 * 
	 * @parameter Instance of AddSuffixRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default AddSuffixRoleMapperConsumer<T> andThen(
			AddSuffixRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}