package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AuthenticationContext;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AuthenticationContextConsumer<T extends AuthenticationContext<T>> {

	/**
	 * Configure a pre-constructed instance of AuthenticationContext resource
	 * 
	 * @parameter Instance of AuthenticationContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default AuthenticationContextConsumer<T> andThen(
			AuthenticationContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}