package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A realm definition that enables caching to another security realm. Caching
 * strategy is LRU (Least Recently Used) where least accessed entries are
 * discarded when maximum number of entries is reached.
 */
@Address("/subsystem=elytron/caching-realm=*")
@ResourceType("caching-realm")
public class CachingRealm<T extends CachingRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The time in milliseconds that an item can stay in the cache.")
	private Long maximumAge;
	@AttributeDocumentation("The maximum number of entries to keep in the cache.")
	private Integer maximumEntries;
	@AttributeDocumentation("A reference to a cacheable security realm.")
	private String realm;

	public CachingRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The time in milliseconds that an item can stay in the cache.
	 */
	@ModelNodeBinding(detypedName = "maximum-age")
	public Long maximumAge() {
		return this.maximumAge;
	}

	/**
	 * The time in milliseconds that an item can stay in the cache.
	 */
	@SuppressWarnings("unchecked")
	public T maximumAge(java.lang.Long value) {
		Object oldValue = this.maximumAge;
		this.maximumAge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maximumAge", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of entries to keep in the cache.
	 */
	@ModelNodeBinding(detypedName = "maximum-entries")
	public Integer maximumEntries() {
		return this.maximumEntries;
	}

	/**
	 * The maximum number of entries to keep in the cache.
	 */
	@SuppressWarnings("unchecked")
	public T maximumEntries(java.lang.Integer value) {
		Object oldValue = this.maximumEntries;
		this.maximumEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maximumEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a cacheable security realm.
	 */
	@ModelNodeBinding(detypedName = "realm")
	public String realm() {
		return this.realm;
	}

	/**
	 * A reference to a cacheable security realm.
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.lang.String value) {
		Object oldValue = this.realm;
		this.realm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realm", oldValue, value);
		return (T) this;
	}
}