package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CachingRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CachingRealmConsumer<T extends CachingRealm<T>> {

	/**
	 * Configure a pre-constructed instance of CachingRealm resource
	 * 
	 * @parameter Instance of CachingRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default CachingRealmConsumer<T> andThen(CachingRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}