package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CertificateAuthorityAccount;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CertificateAuthorityAccountConsumer<T extends CertificateAuthorityAccount<T>> {

	/**
	 * Configure a pre-constructed instance of CertificateAuthorityAccount
	 * resource
	 * 
	 * @parameter Instance of CertificateAuthorityAccount to configure
	 * @return nothing
	 */
	void accept(T value);

	default CertificateAuthorityAccountConsumer<T> andThen(
			CertificateAuthorityAccountConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}