package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A principal transformer definition where the principal transformer is a
 * chaining of other principal transformers.
 */
@Address("/subsystem=elytron/chained-principal-transformer=*")
@ResourceType("chained-principal-transformer")
public class ChainedPrincipalTransformer<T extends ChainedPrincipalTransformer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The referenced principal transformers to chain.")
	private List<String> principalTransformers;

	public ChainedPrincipalTransformer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The referenced principal transformers to chain.
	 */
	@ModelNodeBinding(detypedName = "principal-transformers")
	public List<String> principalTransformers() {
		return this.principalTransformers;
	}

	/**
	 * The referenced principal transformers to chain.
	 */
	@SuppressWarnings("unchecked")
	public T principalTransformers(java.util.List<String> value) {
		Object oldValue = this.principalTransformers;
		this.principalTransformers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalTransformers", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The referenced principal transformers to chain.
	 */
	@SuppressWarnings("unchecked")
	public T principalTransformer(String value) {
		if (this.principalTransformers == null) {
			this.principalTransformers = new java.util.ArrayList<>();
		}
		this.principalTransformers.add(value);
		return (T) this;
	}

	/**
	 * The referenced principal transformers to chain.
	 */
	@SuppressWarnings("unchecked")
	public T principalTransformers(String... args) {
		principalTransformers(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}