package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.elytron.SslSessionConsumer;
import org.wildfly.swarm.config.elytron.SslSessionSupplier;
import org.wildfly.swarm.config.elytron.SslSession;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An SSLContext for use on the client side of a connection.
 */
@Address("/subsystem=elytron/client-ssl-context=*")
@ResourceType("client-ssl-context")
public class ClientSslContext<T extends ClientSslContext<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ClientSslContextResources subresources = new ClientSslContextResources();
	@AttributeDocumentation("The count of current active sessions.")
	private Integer activeSessionCount;
	@AttributeDocumentation("The filter to apply to specify the enabled cipher suites.")
	private String cipherSuiteFilter;
	@AttributeDocumentation("Reference to the key manager to use within the SSLContext.")
	private String keyManager;
	@AttributeDocumentation("The enabled protocols.")
	private List<String> protocols;
	@AttributeDocumentation("The name of the provider to use. If not specified, all providers from providers will be passed to the SSLContext.")
	private String providerName;
	@AttributeDocumentation("The name of the providers to obtain the Provider[] to use to load the SSLContext.")
	private String providers;
	@AttributeDocumentation("Reference to the trust manager to use within the SSLContext.")
	private String trustManager;

	public ClientSslContext(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ClientSslContextResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all SslSession objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SslSession objects.
	 */
	@SuppressWarnings("unchecked")
	public T sslSessions(java.util.List<SslSession> value) {
		this.subresources.sslSessions = value;
		return (T) this;
	}

	/**
	 * Add the SslSession object to the list of subresources
	 * 
	 * @param value
	 *            The SslSession to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sslSession(SslSession value) {
		this.subresources.sslSessions.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SslSession object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SslSession resource
	 * @param config
	 *            The SslSessionConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sslSession(java.lang.String childKey, SslSessionConsumer consumer) {
		SslSession<? extends SslSession> child = new SslSession<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		sslSession(child);
		return (T) this;
	}

	/**
	 * Create and configure a SslSession object to the list of subresources
	 * 
	 * @param key
	 *            The key for the SslSession resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T sslSession(java.lang.String childKey) {
		sslSession(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SslSession object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T sslSession(SslSessionSupplier supplier) {
		sslSession(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ClientSslContext
	 */
	public static class ClientSslContextResources {
		/**
		 * A currently established SSL session.
		 */
		@ResourceDocumentation("A currently established SSL session.")
		@SubresourceInfo("sslSession")
		private List<SslSession> sslSessions = new java.util.ArrayList<>();

		/**
		 * Get the list of SslSession resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SslSession> sslSessions() {
			return this.sslSessions;
		}

		public SslSession sslSession(java.lang.String key) {
			return this.sslSessions.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The count of current active sessions.
	 */
	@ModelNodeBinding(detypedName = "active-session-count")
	public Integer activeSessionCount() {
		return this.activeSessionCount;
	}

	/**
	 * The count of current active sessions.
	 */
	@SuppressWarnings("unchecked")
	public T activeSessionCount(java.lang.Integer value) {
		Object oldValue = this.activeSessionCount;
		this.activeSessionCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activeSessionCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The filter to apply to specify the enabled cipher suites.
	 */
	@ModelNodeBinding(detypedName = "cipher-suite-filter")
	public String cipherSuiteFilter() {
		return this.cipherSuiteFilter;
	}

	/**
	 * The filter to apply to specify the enabled cipher suites.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuiteFilter(java.lang.String value) {
		Object oldValue = this.cipherSuiteFilter;
		this.cipherSuiteFilter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cipherSuiteFilter", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the key manager to use within the SSLContext.
	 */
	@ModelNodeBinding(detypedName = "key-manager")
	public String keyManager() {
		return this.keyManager;
	}

	/**
	 * Reference to the key manager to use within the SSLContext.
	 */
	@SuppressWarnings("unchecked")
	public T keyManager(java.lang.String value) {
		Object oldValue = this.keyManager;
		this.keyManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyManager", oldValue, value);
		return (T) this;
	}

	/**
	 * The enabled protocols.
	 */
	@ModelNodeBinding(detypedName = "protocols")
	public List<String> protocols() {
		return this.protocols;
	}

	/**
	 * The enabled protocols.
	 */
	@SuppressWarnings("unchecked")
	public T protocols(java.util.List<String> value) {
		Object oldValue = this.protocols;
		this.protocols = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocols", oldValue, value);
		return (T) this;
	}

	/**
	 * The enabled protocols.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(String value) {
		if (this.protocols == null) {
			this.protocols = new java.util.ArrayList<>();
		}
		this.protocols.add(value);
		return (T) this;
	}

	/**
	 * The enabled protocols.
	 */
	@SuppressWarnings("unchecked")
	public T protocols(String... args) {
		protocols(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The name of the provider to use. If not specified, all providers from
	 * providers will be passed to the SSLContext.
	 */
	@ModelNodeBinding(detypedName = "provider-name")
	public String providerName() {
		return this.providerName;
	}

	/**
	 * The name of the provider to use. If not specified, all providers from
	 * providers will be passed to the SSLContext.
	 */
	@SuppressWarnings("unchecked")
	public T providerName(java.lang.String value) {
		Object oldValue = this.providerName;
		this.providerName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providerName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the providers to obtain the Provider[] to use to load the
	 * SSLContext.
	 */
	@ModelNodeBinding(detypedName = "providers")
	public String providers() {
		return this.providers;
	}

	/**
	 * The name of the providers to obtain the Provider[] to use to load the
	 * SSLContext.
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.lang.String value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the trust manager to use within the SSLContext.
	 */
	@ModelNodeBinding(detypedName = "trust-manager")
	public String trustManager() {
		return this.trustManager;
	}

	/**
	 * Reference to the trust manager to use within the SSLContext.
	 */
	@SuppressWarnings("unchecked")
	public T trustManager(java.lang.String value) {
		Object oldValue = this.trustManager;
		this.trustManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trustManager", oldValue, value);
		return (T) this;
	}
}