package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConfigurableHTTPServerMechanismFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigurableHTTPServerMechanismFactoryConsumer<T extends ConfigurableHTTPServerMechanismFactory<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * ConfigurableHTTPServerMechanismFactory resource
	 * 
	 * @parameter Instance of ConfigurableHTTPServerMechanismFactory to
	 *            configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigurableHTTPServerMechanismFactoryConsumer<T> andThen(
			ConfigurableHTTPServerMechanismFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}