package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConstantPermissionMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConstantPermissionMapperConsumer<T extends ConstantPermissionMapper<T>> {

	/**
	 * Configure a pre-constructed instance of ConstantPermissionMapper resource
	 * 
	 * @parameter Instance of ConstantPermissionMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConstantPermissionMapperConsumer<T> andThen(
			ConstantPermissionMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}