package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomPrincipalDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomPrincipalDecoderConsumer<T extends CustomPrincipalDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of CustomPrincipalDecoder resource
	 * 
	 * @parameter Instance of CustomPrincipalDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomPrincipalDecoderConsumer<T> andThen(
			CustomPrincipalDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}