package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomSecurityEventListener;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomSecurityEventListenerConsumer<T extends CustomSecurityEventListener<T>> {

	/**
	 * Configure a pre-constructed instance of CustomSecurityEventListener
	 * resource
	 * 
	 * @parameter Instance of CustomSecurityEventListener to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomSecurityEventListenerConsumer<T> andThen(
			CustomSecurityEventListenerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}