package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.State;

/**
 * A filtering KeyStore definition.
 */
@Address("/subsystem=elytron/filtering-key-store=*")
@ResourceType("filtering-key-store")
public class FilteringKeyStore<T extends FilteringKeyStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
	private String aliasFilter;
	@AttributeDocumentation("Name of filtered KeyStore.")
	private String keyStore;
	@AttributeDocumentation("The state of the underlying service that represents this KeyStore at runtime, if it is anything other than UP runtime operations will not be available.")
	private State state;

	public FilteringKeyStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A filter to apply to the aliases returned from the KeyStore, can either
	 * be a comma separated list of aliases to return or one of the following
	 * formats ALL:-alias1:-alias2, NONE:+alias1:+alias2
	 */
	@ModelNodeBinding(detypedName = "alias-filter")
	public String aliasFilter() {
		return this.aliasFilter;
	}

	/**
	 * A filter to apply to the aliases returned from the KeyStore, can either
	 * be a comma separated list of aliases to return or one of the following
	 * formats ALL:-alias1:-alias2, NONE:+alias1:+alias2
	 */
	@SuppressWarnings("unchecked")
	public T aliasFilter(java.lang.String value) {
		Object oldValue = this.aliasFilter;
		this.aliasFilter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliasFilter", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of filtered KeyStore.
	 */
	@ModelNodeBinding(detypedName = "key-store")
	public String keyStore() {
		return this.keyStore;
	}

	/**
	 * Name of filtered KeyStore.
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String value) {
		Object oldValue = this.keyStore;
		this.keyStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyStore", oldValue, value);
		return (T) this;
	}

	/**
	 * The state of the underlying service that represents this KeyStore at
	 * runtime, if it is anything other than UP runtime operations will not be
	 * available.
	 */
	@ModelNodeBinding(detypedName = "state")
	public State state() {
		return this.state;
	}

	/**
	 * The state of the underlying service that represents this KeyStore at
	 * runtime, if it is anything other than UP runtime operations will not be
	 * available.
	 */
	@SuppressWarnings("unchecked")
	public T state(State value) {
		Object oldValue = this.state;
		this.state = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("state", oldValue, value);
		return (T) this;
	}
}