package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.JDBCRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JDBCRealmConsumer<T extends JDBCRealm<T>> {

	/**
	 * Configure a pre-constructed instance of JDBCRealm resource
	 * 
	 * @parameter Instance of JDBCRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default JDBCRealmConsumer<T> andThen(JDBCRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}