package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.KerberosSecurityFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KerberosSecurityFactoryConsumer<T extends KerberosSecurityFactory<T>> {

	/**
	 * Configure a pre-constructed instance of KerberosSecurityFactory resource
	 * 
	 * @parameter Instance of KerberosSecurityFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default KerberosSecurityFactoryConsumer<T> andThen(
			KerberosSecurityFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}