package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.State;

/**
 * A LdapKeyStore definition.
 */
@Address("/subsystem=elytron/ldap-key-store=*")
@ResourceType("ldap-key-store")
public class LdapKeyStore<T extends LdapKeyStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of LDAP attribute, where will be item alias stored.")
	private String aliasAttribute;
	@AttributeDocumentation("The name of LDAP attribute, where will be certificate stored.")
	private String certificateAttribute;
	@AttributeDocumentation("The name of LDAP attribute, where will be certificate chain stored.")
	private String certificateChainAttribute;
	@AttributeDocumentation("The encoding of the certificate chain.")
	private String certificateChainEncoding;
	@AttributeDocumentation("The type of the Certificate.")
	private String certificateType;
	@AttributeDocumentation("The name of DirContext, which will be used to communication with LDAP server.")
	private String dirContext;
	@AttributeDocumentation("The LDAP filter for obtaining an item of the KeyStore by alias. If this is not specified then the default value will be (alias_attribute={0}). The string '{0}' will be replaced by the searched alias and the 'alias_attribute' value will be the value of the attribute 'alias-attribute'.")
	private String filterAlias;
	@AttributeDocumentation("The LDAP filter for obtaining an item of the KeyStore by certificate. If this is not specified then the default value will be (certificate_attribute={0}). The string '{0}' will be replaced by searched encoded certificate and the 'certificate_attribute' will be the value of the attribute 'certificate-attribute'.")
	private String filterCertificate;
	@AttributeDocumentation("The LDAP filter for iterating over all items of the KeyStore. If this is not specified then the default value will be (alias_attribute=*). The 'alias_attribute' will be the value of the attribute 'alias-attribute'.")
	private String filterIterate;
	@AttributeDocumentation("The name of LDAP attribute, where will be key stored.")
	private String keyAttribute;
	@AttributeDocumentation("The type of KeyStore, in which will be key serialized to LDAP attribute.")
	private String keyType;
	@AttributeDocumentation("Configuration for item creation. Define how will look LDAP entry of newly created keystore item.")
	private Map newItemTemplate;
	@AttributeDocumentation("The path in LDAP, where will be KeyStore items searched.")
	private String searchPath;
	@AttributeDocumentation("If the LDAP search should be recursive.")
	private Boolean searchRecursive;
	@AttributeDocumentation("The time limit for obtaining keystore items from LDAP.")
	private Integer searchTimeLimit;
	@AttributeDocumentation("The size of LDAP KeyStore in amount of items/aliases.")
	private Integer size;
	@AttributeDocumentation("The state of the underlying service that represents this KeyStore at runtime, if it is anything other than UP runtime operations will not be available.")
	private State state;

	public LdapKeyStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of LDAP attribute, where will be item alias stored.
	 */
	@ModelNodeBinding(detypedName = "alias-attribute")
	public String aliasAttribute() {
		return this.aliasAttribute;
	}

	/**
	 * The name of LDAP attribute, where will be item alias stored.
	 */
	@SuppressWarnings("unchecked")
	public T aliasAttribute(java.lang.String value) {
		Object oldValue = this.aliasAttribute;
		this.aliasAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliasAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of LDAP attribute, where will be certificate stored.
	 */
	@ModelNodeBinding(detypedName = "certificate-attribute")
	public String certificateAttribute() {
		return this.certificateAttribute;
	}

	/**
	 * The name of LDAP attribute, where will be certificate stored.
	 */
	@SuppressWarnings("unchecked")
	public T certificateAttribute(java.lang.String value) {
		Object oldValue = this.certificateAttribute;
		this.certificateAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of LDAP attribute, where will be certificate chain stored.
	 */
	@ModelNodeBinding(detypedName = "certificate-chain-attribute")
	public String certificateChainAttribute() {
		return this.certificateChainAttribute;
	}

	/**
	 * The name of LDAP attribute, where will be certificate chain stored.
	 */
	@SuppressWarnings("unchecked")
	public T certificateChainAttribute(java.lang.String value) {
		Object oldValue = this.certificateChainAttribute;
		this.certificateChainAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateChainAttribute", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The encoding of the certificate chain.
	 */
	@ModelNodeBinding(detypedName = "certificate-chain-encoding")
	public String certificateChainEncoding() {
		return this.certificateChainEncoding;
	}

	/**
	 * The encoding of the certificate chain.
	 */
	@SuppressWarnings("unchecked")
	public T certificateChainEncoding(java.lang.String value) {
		Object oldValue = this.certificateChainEncoding;
		this.certificateChainEncoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateChainEncoding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The type of the Certificate.
	 */
	@ModelNodeBinding(detypedName = "certificate-type")
	public String certificateType() {
		return this.certificateType;
	}

	/**
	 * The type of the Certificate.
	 */
	@SuppressWarnings("unchecked")
	public T certificateType(java.lang.String value) {
		Object oldValue = this.certificateType;
		this.certificateType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateType", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of DirContext, which will be used to communication with LDAP
	 * server.
	 */
	@ModelNodeBinding(detypedName = "dir-context")
	public String dirContext() {
		return this.dirContext;
	}

	/**
	 * The name of DirContext, which will be used to communication with LDAP
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(java.lang.String value) {
		Object oldValue = this.dirContext;
		this.dirContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dirContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The LDAP filter for obtaining an item of the KeyStore by alias. If this
	 * is not specified then the default value will be (alias_attribute={0}).
	 * The string '{0}' will be replaced by the searched alias and the
	 * 'alias_attribute' value will be the value of the attribute
	 * 'alias-attribute'.
	 */
	@ModelNodeBinding(detypedName = "filter-alias")
	public String filterAlias() {
		return this.filterAlias;
	}

	/**
	 * The LDAP filter for obtaining an item of the KeyStore by alias. If this
	 * is not specified then the default value will be (alias_attribute={0}).
	 * The string '{0}' will be replaced by the searched alias and the
	 * 'alias_attribute' value will be the value of the attribute
	 * 'alias-attribute'.
	 */
	@SuppressWarnings("unchecked")
	public T filterAlias(java.lang.String value) {
		Object oldValue = this.filterAlias;
		this.filterAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * The LDAP filter for obtaining an item of the KeyStore by certificate. If
	 * this is not specified then the default value will be
	 * (certificate_attribute={0}). The string '{0}' will be replaced by
	 * searched encoded certificate and the 'certificate_attribute' will be the
	 * value of the attribute 'certificate-attribute'.
	 */
	@ModelNodeBinding(detypedName = "filter-certificate")
	public String filterCertificate() {
		return this.filterCertificate;
	}

	/**
	 * The LDAP filter for obtaining an item of the KeyStore by certificate. If
	 * this is not specified then the default value will be
	 * (certificate_attribute={0}). The string '{0}' will be replaced by
	 * searched encoded certificate and the 'certificate_attribute' will be the
	 * value of the attribute 'certificate-attribute'.
	 */
	@SuppressWarnings("unchecked")
	public T filterCertificate(java.lang.String value) {
		Object oldValue = this.filterCertificate;
		this.filterCertificate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterCertificate", oldValue, value);
		return (T) this;
	}

	/**
	 * The LDAP filter for iterating over all items of the KeyStore. If this is
	 * not specified then the default value will be (alias_attribute=*). The
	 * 'alias_attribute' will be the value of the attribute 'alias-attribute'.
	 */
	@ModelNodeBinding(detypedName = "filter-iterate")
	public String filterIterate() {
		return this.filterIterate;
	}

	/**
	 * The LDAP filter for iterating over all items of the KeyStore. If this is
	 * not specified then the default value will be (alias_attribute=*). The
	 * 'alias_attribute' will be the value of the attribute 'alias-attribute'.
	 */
	@SuppressWarnings("unchecked")
	public T filterIterate(java.lang.String value) {
		Object oldValue = this.filterIterate;
		this.filterIterate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterIterate", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of LDAP attribute, where will be key stored.
	 */
	@ModelNodeBinding(detypedName = "key-attribute")
	public String keyAttribute() {
		return this.keyAttribute;
	}

	/**
	 * The name of LDAP attribute, where will be key stored.
	 */
	@SuppressWarnings("unchecked")
	public T keyAttribute(java.lang.String value) {
		Object oldValue = this.keyAttribute;
		this.keyAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of KeyStore, in which will be key serialized to LDAP attribute.
	 */
	@ModelNodeBinding(detypedName = "key-type")
	public String keyType() {
		return this.keyType;
	}

	/**
	 * The type of KeyStore, in which will be key serialized to LDAP attribute.
	 */
	@SuppressWarnings("unchecked")
	public T keyType(java.lang.String value) {
		Object oldValue = this.keyType;
		this.keyType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyType", oldValue, value);
		return (T) this;
	}

	/**
	 * Configuration for item creation. Define how will look LDAP entry of newly
	 * created keystore item.
	 */
	@ModelNodeBinding(detypedName = "new-item-template")
	public Map newItemTemplate() {
		return this.newItemTemplate;
	}

	/**
	 * Configuration for item creation. Define how will look LDAP entry of newly
	 * created keystore item.
	 */
	@SuppressWarnings("unchecked")
	public T newItemTemplate(java.util.Map value) {
		Object oldValue = this.newItemTemplate;
		this.newItemTemplate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("newItemTemplate", oldValue, value);
		return (T) this;
	}

	/**
	 * Configuration for item creation. Define how will look LDAP entry of newly
	 * created keystore item.
	 */
	@SuppressWarnings("unchecked")
	public T newItemTemplate(java.lang.String key, java.lang.Object value) {
		if (this.newItemTemplate == null) {
			this.newItemTemplate = new java.util.HashMap<>();
		}
		this.newItemTemplate.put(key, value);
		return (T) this;
	}

	/**
	 * The path in LDAP, where will be KeyStore items searched.
	 */
	@ModelNodeBinding(detypedName = "search-path")
	public String searchPath() {
		return this.searchPath;
	}

	/**
	 * The path in LDAP, where will be KeyStore items searched.
	 */
	@SuppressWarnings("unchecked")
	public T searchPath(java.lang.String value) {
		Object oldValue = this.searchPath;
		this.searchPath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("searchPath", oldValue, value);
		return (T) this;
	}

	/**
	 * If the LDAP search should be recursive.
	 */
	@ModelNodeBinding(detypedName = "search-recursive")
	public Boolean searchRecursive() {
		return this.searchRecursive;
	}

	/**
	 * If the LDAP search should be recursive.
	 */
	@SuppressWarnings("unchecked")
	public T searchRecursive(java.lang.Boolean value) {
		Object oldValue = this.searchRecursive;
		this.searchRecursive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("searchRecursive", oldValue, value);
		return (T) this;
	}

	/**
	 * The time limit for obtaining keystore items from LDAP.
	 */
	@ModelNodeBinding(detypedName = "search-time-limit")
	public Integer searchTimeLimit() {
		return this.searchTimeLimit;
	}

	/**
	 * The time limit for obtaining keystore items from LDAP.
	 */
	@SuppressWarnings("unchecked")
	public T searchTimeLimit(java.lang.Integer value) {
		Object oldValue = this.searchTimeLimit;
		this.searchTimeLimit = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("searchTimeLimit", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of LDAP KeyStore in amount of items/aliases.
	 */
	@ModelNodeBinding(detypedName = "size")
	public Integer size() {
		return this.size;
	}

	/**
	 * The size of LDAP KeyStore in amount of items/aliases.
	 */
	@SuppressWarnings("unchecked")
	public T size(java.lang.Integer value) {
		Object oldValue = this.size;
		this.size = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("size", oldValue, value);
		return (T) this;
	}

	/**
	 * The state of the underlying service that represents this KeyStore at
	 * runtime, if it is anything other than UP runtime operations will not be
	 * available.
	 */
	@ModelNodeBinding(detypedName = "state")
	public State state() {
		return this.state;
	}

	/**
	 * The state of the underlying service that represents this KeyStore at
	 * runtime, if it is anything other than UP runtime operations will not be
	 * available.
	 */
	@SuppressWarnings("unchecked")
	public T state(State value) {
		Object oldValue = this.state;
		this.state = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("state", oldValue, value);
		return (T) this;
	}
}