package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A security realm definition backed by LDAP.
 */
@Address("/subsystem=elytron/ldap-realm=*")
@ResourceType("ldap-realm")
public class LdapRealm<T extends LdapRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Does this realm support blank password direct verification? Blank password attempt will be rejected otherwise.")
	private Boolean allowBlankPassword;
	@AttributeDocumentation("The configuration to connect to a LDAP server.")
	private String dirContext;
	@AttributeDocumentation("Does this realm support verification of credentials by directly connecting to LDAP as the account being authenticated?")
	private Boolean directVerification;
	@AttributeDocumentation("The configuration options that define how principals are mapped to their corresponding entries in the underlying LDAP server.")
	private Map identityMapping;

	public LdapRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Does this realm support blank password direct verification? Blank
	 * password attempt will be rejected otherwise.
	 */
	@ModelNodeBinding(detypedName = "allow-blank-password")
	public Boolean allowBlankPassword() {
		return this.allowBlankPassword;
	}

	/**
	 * Does this realm support blank password direct verification? Blank
	 * password attempt will be rejected otherwise.
	 */
	@SuppressWarnings("unchecked")
	public T allowBlankPassword(java.lang.Boolean value) {
		Object oldValue = this.allowBlankPassword;
		this.allowBlankPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowBlankPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The configuration to connect to a LDAP server.
	 */
	@ModelNodeBinding(detypedName = "dir-context")
	public String dirContext() {
		return this.dirContext;
	}

	/**
	 * The configuration to connect to a LDAP server.
	 */
	@SuppressWarnings("unchecked")
	public T dirContext(java.lang.String value) {
		Object oldValue = this.dirContext;
		this.dirContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dirContext", oldValue, value);
		return (T) this;
	}

	/**
	 * Does this realm support verification of credentials by directly
	 * connecting to LDAP as the account being authenticated?
	 */
	@ModelNodeBinding(detypedName = "direct-verification")
	public Boolean directVerification() {
		return this.directVerification;
	}

	/**
	 * Does this realm support verification of credentials by directly
	 * connecting to LDAP as the account being authenticated?
	 */
	@SuppressWarnings("unchecked")
	public T directVerification(java.lang.Boolean value) {
		Object oldValue = this.directVerification;
		this.directVerification = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("directVerification", oldValue, value);
		return (T) this;
	}

	/**
	 * The configuration options that define how principals are mapped to their
	 * corresponding entries in the underlying LDAP server.
	 */
	@ModelNodeBinding(detypedName = "identity-mapping")
	public Map identityMapping() {
		return this.identityMapping;
	}

	/**
	 * The configuration options that define how principals are mapped to their
	 * corresponding entries in the underlying LDAP server.
	 */
	@SuppressWarnings("unchecked")
	public T identityMapping(java.util.Map value) {
		Object oldValue = this.identityMapping;
		this.identityMapping = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("identityMapping", oldValue, value);
		return (T) this;
	}

	/**
	 * The configuration options that define how principals are mapped to their
	 * corresponding entries in the underlying LDAP server.
	 */
	@SuppressWarnings("unchecked")
	public T identityMapping(java.lang.String key, java.lang.Object value) {
		if (this.identityMapping == null) {
			this.identityMapping = new java.util.HashMap<>();
		}
		this.identityMapping.put(key, value);
		return (T) this;
	}
}