package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A RoleMapper definition for a RoleMapper that performs a mapping based on
 * configured map.
 */
@Address("/subsystem=elytron/mapped-role-mapper=*")
@ResourceType("mapped-role-mapper")
public class MappedRoleMapper<T extends MappedRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("When set to 'true' the mapped roles will retain all roles, that have defined mappings.")
	private Boolean keepMapped;
	@AttributeDocumentation("When set to 'true' the mapped roles will retain all roles, that have no defined mappings.")
	private Boolean keepNonMapped;
	@AttributeDocumentation("A string to string list map for mapping roles.")
	private Map roleMap;

	public MappedRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * When set to 'true' the mapped roles will retain all roles, that have
	 * defined mappings.
	 */
	@ModelNodeBinding(detypedName = "keep-mapped")
	public Boolean keepMapped() {
		return this.keepMapped;
	}

	/**
	 * When set to 'true' the mapped roles will retain all roles, that have
	 * defined mappings.
	 */
	@SuppressWarnings("unchecked")
	public T keepMapped(java.lang.Boolean value) {
		Object oldValue = this.keepMapped;
		this.keepMapped = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepMapped", oldValue, value);
		return (T) this;
	}

	/**
	 * When set to 'true' the mapped roles will retain all roles, that have no
	 * defined mappings.
	 */
	@ModelNodeBinding(detypedName = "keep-non-mapped")
	public Boolean keepNonMapped() {
		return this.keepNonMapped;
	}

	/**
	 * When set to 'true' the mapped roles will retain all roles, that have no
	 * defined mappings.
	 */
	@SuppressWarnings("unchecked")
	public T keepNonMapped(java.lang.Boolean value) {
		Object oldValue = this.keepNonMapped;
		this.keepNonMapped = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepNonMapped", oldValue, value);
		return (T) this;
	}

	/**
	 * A string to string list map for mapping roles.
	 */
	@ModelNodeBinding(detypedName = "role-map")
	public Map roleMap() {
		return this.roleMap;
	}

	/**
	 * A string to string list map for mapping roles.
	 */
	@SuppressWarnings("unchecked")
	public T roleMap(java.util.Map value) {
		Object oldValue = this.roleMap;
		this.roleMap = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("roleMap", oldValue, value);
		return (T) this;
	}

	/**
	 * A string to string list map for mapping roles.
	 */
	@SuppressWarnings("unchecked")
	public T roleMap(java.lang.String key, java.lang.Object value) {
		if (this.roleMap == null) {
			this.roleMap = new java.util.HashMap<>();
		}
		this.roleMap.put(key, value);
		return (T) this;
	}
}