package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.MappedRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MappedRoleMapperConsumer<T extends MappedRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of MappedRoleMapper resource
	 * 
	 * @parameter Instance of MappedRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default MappedRoleMapperConsumer<T> andThen(
			MappedRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}