package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * A SaslServerFactory definition that wraps another SaslServerFactory and
 * enables filtering of mechanisms based on the mechanism name and Provider name
 * and version. Any mechanisms loaded by factories not located using a Provider
 * will not be filtered by this definition.
 */
@Address("/subsystem=elytron/mechanism-provider-filtering-sasl-server-factory=*")
@ResourceType("mechanism-provider-filtering-sasl-server-factory")
public class MechanismProviderFilteringSASLServerFactory<T extends MechanismProviderFilteringSASLServerFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL mechanisms available from this factory after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("When set to 'true' no provider loaded mechanisms are enabled unless matched by one of the filters, setting to 'false' has the inverse effect.")
	private Boolean enabling;
	@AttributeDocumentation("The filters to apply when comparing the mechanisms from the providers, a filter matches when all of the specified values match the mechanism / provider pair.")
	private List<java.util.Map> filters;
	@AttributeDocumentation("Reference to a sasl server factory to be wrapped by this definition.")
	private String saslServerFactory;

	public MechanismProviderFilteringSASLServerFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * When set to 'true' no provider loaded mechanisms are enabled unless
	 * matched by one of the filters, setting to 'false' has the inverse effect.
	 */
	@ModelNodeBinding(detypedName = "enabling")
	public Boolean enabling() {
		return this.enabling;
	}

	/**
	 * When set to 'true' no provider loaded mechanisms are enabled unless
	 * matched by one of the filters, setting to 'false' has the inverse effect.
	 */
	@SuppressWarnings("unchecked")
	public T enabling(java.lang.Boolean value) {
		Object oldValue = this.enabling;
		this.enabling = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabling", oldValue, value);
		return (T) this;
	}

	/**
	 * The filters to apply when comparing the mechanisms from the providers, a
	 * filter matches when all of the specified values match the mechanism /
	 * provider pair.
	 */
	@ModelNodeBinding(detypedName = "filters")
	public List<Map> filters() {
		return this.filters;
	}

	/**
	 * The filters to apply when comparing the mechanisms from the providers, a
	 * filter matches when all of the specified values match the mechanism /
	 * provider pair.
	 */
	@SuppressWarnings("unchecked")
	public T filters(java.util.List<java.util.Map> value) {
		Object oldValue = this.filters;
		this.filters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filters", oldValue, value);
		return (T) this;
	}

	/**
	 * The filters to apply when comparing the mechanisms from the providers, a
	 * filter matches when all of the specified values match the mechanism /
	 * provider pair.
	 */
	@SuppressWarnings("unchecked")
	public T filter(java.util.Map value) {
		if (this.filters == null) {
			this.filters = new java.util.ArrayList<>();
		}
		this.filters.add(value);
		return (T) this;
	}

	/**
	 * The filters to apply when comparing the mechanisms from the providers, a
	 * filter matches when all of the specified values match the mechanism /
	 * provider pair.
	 */
	@SuppressWarnings("unchecked")
	public T filters(java.util.Map... args) {
		filters(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Reference to a sasl server factory to be wrapped by this definition.
	 */
	@ModelNodeBinding(detypedName = "sasl-server-factory")
	public String saslServerFactory() {
		return this.saslServerFactory;
	}

	/**
	 * Reference to a sasl server factory to be wrapped by this definition.
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactory(java.lang.String value) {
		Object oldValue = this.saslServerFactory;
		this.saslServerFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslServerFactory", oldValue, value);
		return (T) this;
	}
}