package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.MechanismProviderFilteringSASLServerFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MechanismProviderFilteringSASLServerFactoryConsumer<T extends MechanismProviderFilteringSASLServerFactory<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * MechanismProviderFilteringSASLServerFactory resource
	 * 
	 * @parameter Instance of MechanismProviderFilteringSASLServerFactory to
	 *            configure
	 * @return nothing
	 */
	void accept(T value);

	default MechanismProviderFilteringSASLServerFactoryConsumer<T> andThen(
			MechanismProviderFilteringSASLServerFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}