package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.PermissionSet;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PermissionSetConsumer<T extends PermissionSet<T>> {

	/**
	 * Configure a pre-constructed instance of PermissionSet resource
	 * 
	 * @parameter Instance of PermissionSet to configure
	 * @return nothing
	 */
	void accept(T value);

	default PermissionSetConsumer<T> andThen(PermissionSetConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}