package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.PropertiesRealm;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PropertiesRealmConsumer<T extends PropertiesRealm<T>> {

	/**
	 * Configure a pre-constructed instance of PropertiesRealm resource
	 * 
	 * @parameter Instance of PropertiesRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default PropertiesRealmConsumer<T> andThen(PropertiesRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}