package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.RegexPrincipalTransformer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RegexPrincipalTransformerConsumer<T extends RegexPrincipalTransformer<T>> {

	/**
	 * Configure a pre-constructed instance of RegexPrincipalTransformer
	 * resource
	 * 
	 * @parameter Instance of RegexPrincipalTransformer to configure
	 * @return nothing
	 */
	void accept(T value);

	default RegexPrincipalTransformerConsumer<T> andThen(
			RegexPrincipalTransformerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}