package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SASLAuthenticationFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SASLAuthenticationFactoryConsumer<T extends SASLAuthenticationFactory<T>> {

	/**
	 * Configure a pre-constructed instance of SASLAuthenticationFactory
	 * resource
	 * 
	 * @parameter Instance of SASLAuthenticationFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default SASLAuthenticationFactoryConsumer<T> andThen(
			SASLAuthenticationFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}