package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ServerSslSniContext;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServerSslSniContextConsumer<T extends ServerSslSniContext<T>> {

	/**
	 * Configure a pre-constructed instance of ServerSslSniContext resource
	 * 
	 * @parameter Instance of ServerSslSniContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServerSslSniContextConsumer<T> andThen(
			ServerSslSniContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}