package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A sasl server factory definition where the sasl server factory is an
 * aggregation of factories identified using a ServiceLoader
 */
@Address("/subsystem=elytron/service-loader-sasl-server-factory=*")
@ResourceType("service-loader-sasl-server-factory")
public class ServiceLoaderSASLServerFactory<T extends ServiceLoaderSASLServerFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL mechanisms available from this factory after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("The module to use to obtain the classloader to load the factories, if not specified the classloader to load the resource will be used instead.")
	private String module;

	public ServiceLoaderSASLServerFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The module to use to obtain the classloader to load the factories, if not
	 * specified the classloader to load the resource will be used instead.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module to use to obtain the classloader to load the factories, if not
	 * specified the classloader to load the resource will be used instead.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}
}