package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.Format;

/**
 * An audit log definition for persisting an audit log to a local files rotating
 * the log after the size of the file grows beyond a certain point and keeping a
 * fixed number of backups.
 */
@Address("/subsystem=elytron/size-rotating-file-audit-log=*")
@ResourceType("size-rotating-file-audit-log")
public class SizeRotatingFileAuditLog<T extends SizeRotatingFileAuditLog<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether every event should be immediately flushed to disk.")
	private Boolean autoflush;
	@AttributeDocumentation("The format to use to record the audit event.")
	private Format format;
	@AttributeDocumentation("The maximum number of files to backup when rotating.")
	private Integer maxBackupIndex;
	@AttributeDocumentation("Path of the file to be written.")
	private String path;
	@AttributeDocumentation("The relative path to the audit log.")
	private String relativeTo;
	@AttributeDocumentation("Whether the file should be rotated before the a new file is set.")
	private Boolean rotateOnBoot;
	@AttributeDocumentation("The log file size the file should rotate at.")
	private String rotateSize;
	@AttributeDocumentation("Format of date used as suffix of log file names in java.time.format.DateTimeFormatter. The suffix does not play a role in determining when the file should be rotated.")
	private String suffix;
	@AttributeDocumentation("Whether every event should be immediately flushed to disk (If undefined will default to the value of synchronized).")
	private Boolean attributeSynchronized;

	public SizeRotatingFileAuditLog(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether every event should be immediately flushed to disk.
	 */
	@ModelNodeBinding(detypedName = "autoflush")
	public Boolean autoflush() {
		return this.autoflush;
	}

	/**
	 * Whether every event should be immediately flushed to disk.
	 */
	@SuppressWarnings("unchecked")
	public T autoflush(java.lang.Boolean value) {
		Object oldValue = this.autoflush;
		this.autoflush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoflush", oldValue, value);
		return (T) this;
	}

	/**
	 * The format to use to record the audit event.
	 */
	@ModelNodeBinding(detypedName = "format")
	public Format format() {
		return this.format;
	}

	/**
	 * The format to use to record the audit event.
	 */
	@SuppressWarnings("unchecked")
	public T format(Format value) {
		Object oldValue = this.format;
		this.format = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("format", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of files to backup when rotating.
	 */
	@ModelNodeBinding(detypedName = "max-backup-index")
	public Integer maxBackupIndex() {
		return this.maxBackupIndex;
	}

	/**
	 * The maximum number of files to backup when rotating.
	 */
	@SuppressWarnings("unchecked")
	public T maxBackupIndex(java.lang.Integer value) {
		Object oldValue = this.maxBackupIndex;
		this.maxBackupIndex = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxBackupIndex", oldValue, value);
		return (T) this;
	}

	/**
	 * Path of the file to be written.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Path of the file to be written.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The relative path to the audit log.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The relative path to the audit log.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the file should be rotated before the a new file is set.
	 */
	@ModelNodeBinding(detypedName = "rotate-on-boot")
	public Boolean rotateOnBoot() {
		return this.rotateOnBoot;
	}

	/**
	 * Whether the file should be rotated before the a new file is set.
	 */
	@SuppressWarnings("unchecked")
	public T rotateOnBoot(java.lang.Boolean value) {
		Object oldValue = this.rotateOnBoot;
		this.rotateOnBoot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rotateOnBoot", oldValue, value);
		return (T) this;
	}

	/**
	 * The log file size the file should rotate at.
	 */
	@ModelNodeBinding(detypedName = "rotate-size")
	public String rotateSize() {
		return this.rotateSize;
	}

	/**
	 * The log file size the file should rotate at.
	 */
	@SuppressWarnings("unchecked")
	public T rotateSize(java.lang.String value) {
		Object oldValue = this.rotateSize;
		this.rotateSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rotateSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Format of date used as suffix of log file names in
	 * java.time.format.DateTimeFormatter. The suffix does not play a role in
	 * determining when the file should be rotated.
	 */
	@ModelNodeBinding(detypedName = "suffix")
	public String suffix() {
		return this.suffix;
	}

	/**
	 * Format of date used as suffix of log file names in
	 * java.time.format.DateTimeFormatter. The suffix does not play a role in
	 * determining when the file should be rotated.
	 */
	@SuppressWarnings("unchecked")
	public T suffix(java.lang.String value) {
		Object oldValue = this.suffix;
		this.suffix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("suffix", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether every event should be immediately flushed to disk (If undefined
	 * will default to the value of synchronized).
	 */
	@ModelNodeBinding(detypedName = "synchronized")
	public Boolean attributeSynchronized() {
		return this.attributeSynchronized;
	}

	/**
	 * Whether every event should be immediately flushed to disk (If undefined
	 * will default to the value of synchronized).
	 */
	@SuppressWarnings("unchecked")
	public T attributeSynchronized(java.lang.Boolean value) {
		Object oldValue = this.attributeSynchronized;
		this.attributeSynchronized = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeSynchronized", oldValue,
					value);
		return (T) this;
	}
}