package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SslSession;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SslSessionConsumer<T extends SslSession<T>> {

	/**
	 * Configure a pre-constructed instance of SslSession resource
	 * 
	 * @parameter Instance of SslSession to configure
	 * @return nothing
	 */
	void accept(T value);

	default SslSessionConsumer<T> andThen(SslSessionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}