package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SyslogAuditLog;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SyslogAuditLogConsumer<T extends SyslogAuditLog<T>> {

	/**
	 * Configure a pre-constructed instance of SyslogAuditLog resource
	 * 
	 * @parameter Instance of SyslogAuditLog to configure
	 * @return nothing
	 */
	void accept(T value);

	default SyslogAuditLogConsumer<T> andThen(SyslogAuditLogConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}