package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A security realm definition capable of validating and extracting identities
 * from security tokens.
 */
@Address("/subsystem=elytron/token-realm=*")
@ResourceType("token-realm")
public class TokenRealm<T extends TokenRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("A token validator to be used in conjunction with a token-based realm that handles security tokens based on the JWT/JWS standard.")
	private Map jwt;
	@AttributeDocumentation("A token validator to be used in conjunction with a token-based realm that handles OAuth2 Access Tokens and validates them using an endpoint compliant with OAuth2 Token Introspection specification(RFC-7662).")
	private Map oauth2Introspection;
	@AttributeDocumentation("The name of the claim that should be used to obtain the principal's name.")
	private String principalClaim;

	public TokenRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles security tokens based on the JWT/JWS standard.
	 */
	@ModelNodeBinding(detypedName = "jwt")
	public Map jwt() {
		return this.jwt;
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles security tokens based on the JWT/JWS standard.
	 */
	@SuppressWarnings("unchecked")
	public T jwt(java.util.Map value) {
		Object oldValue = this.jwt;
		this.jwt = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jwt", oldValue, value);
		return (T) this;
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles security tokens based on the JWT/JWS standard.
	 */
	@SuppressWarnings("unchecked")
	public T jwt(java.lang.String key, java.lang.Object value) {
		if (this.jwt == null) {
			this.jwt = new java.util.HashMap<>();
		}
		this.jwt.put(key, value);
		return (T) this;
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles OAuth2 Access Tokens and validates them using an endpoint
	 * compliant with OAuth2 Token Introspection specification(RFC-7662).
	 */
	@ModelNodeBinding(detypedName = "oauth2-introspection")
	public Map oauth2Introspection() {
		return this.oauth2Introspection;
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles OAuth2 Access Tokens and validates them using an endpoint
	 * compliant with OAuth2 Token Introspection specification(RFC-7662).
	 */
	@SuppressWarnings("unchecked")
	public T oauth2Introspection(java.util.Map value) {
		Object oldValue = this.oauth2Introspection;
		this.oauth2Introspection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("oauth2Introspection", oldValue, value);
		return (T) this;
	}

	/**
	 * A token validator to be used in conjunction with a token-based realm that
	 * handles OAuth2 Access Tokens and validates them using an endpoint
	 * compliant with OAuth2 Token Introspection specification(RFC-7662).
	 */
	@SuppressWarnings("unchecked")
	public T oauth2Introspection(java.lang.String key, java.lang.Object value) {
		if (this.oauth2Introspection == null) {
			this.oauth2Introspection = new java.util.HashMap<>();
		}
		this.oauth2Introspection.put(key, value);
		return (T) this;
	}

	/**
	 * The name of the claim that should be used to obtain the principal's name.
	 */
	@ModelNodeBinding(detypedName = "principal-claim")
	public String principalClaim() {
		return this.principalClaim;
	}

	/**
	 * The name of the claim that should be used to obtain the principal's name.
	 */
	@SuppressWarnings("unchecked")
	public T principalClaim(java.lang.String value) {
		Object oldValue = this.principalClaim;
		this.principalClaim = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalClaim", oldValue, value);
		return (T) this;
	}
}