package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.TrustManager;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TrustManagerConsumer<T extends TrustManager<T>> {

	/**
	 * Configure a pre-constructed instance of TrustManager resource
	 * 
	 * @parameter Instance of TrustManager to configure
	 * @return nothing
	 */
	void accept(T value);

	default TrustManagerConsumer<T> andThen(TrustManagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}