package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Definition of a X.500 attribute based principal decoder
 */
@Address("/subsystem=elytron/x500-attribute-principal-decoder=*")
@ResourceType("x500-attribute-principal-decoder")
public class X500AttributePrincipalDecoder<T extends X500AttributePrincipalDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the X.500 attribute to map (can be defined using OID instead)")
	private String attributeName;
	@AttributeDocumentation("When set to 'true', if the Principal is not already an X500Principal conversion will be attempted")
	private Boolean convert;
	@AttributeDocumentation("The joining string")
	private String joiner;
	@AttributeDocumentation("The maximum number of occurrences of the attribute to map")
	private Integer maximumSegments;
	@AttributeDocumentation("The OID of the X.500 attribute to map (can be defined using attribute name instead)")
	private String oid;
	@AttributeDocumentation("The attributes names of the attributes that must be present in the principal")
	private List<String> requiredAttributes;
	@AttributeDocumentation("The OIDs of the attributes that must be present in the principal")
	private List<String> requiredOids;
	@AttributeDocumentation("When set to 'true', the attribute values will be processed and returned in reverse order")
	private Boolean reverse;
	@AttributeDocumentation("The 0-based starting occurrence of the attribute to map")
	private Integer startSegment;

	public X500AttributePrincipalDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the X.500 attribute to map (can be defined using OID instead)
	 */
	@ModelNodeBinding(detypedName = "attribute-name")
	public String attributeName() {
		return this.attributeName;
	}

	/**
	 * The name of the X.500 attribute to map (can be defined using OID instead)
	 */
	@SuppressWarnings("unchecked")
	public T attributeName(java.lang.String value) {
		Object oldValue = this.attributeName;
		this.attributeName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeName", oldValue, value);
		return (T) this;
	}

	/**
	 * When set to 'true', if the Principal is not already an X500Principal
	 * conversion will be attempted
	 */
	@ModelNodeBinding(detypedName = "convert")
	public Boolean convert() {
		return this.convert;
	}

	/**
	 * When set to 'true', if the Principal is not already an X500Principal
	 * conversion will be attempted
	 */
	@SuppressWarnings("unchecked")
	public T convert(java.lang.Boolean value) {
		Object oldValue = this.convert;
		this.convert = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("convert", oldValue, value);
		return (T) this;
	}

	/**
	 * The joining string
	 */
	@ModelNodeBinding(detypedName = "joiner")
	public String joiner() {
		return this.joiner;
	}

	/**
	 * The joining string
	 */
	@SuppressWarnings("unchecked")
	public T joiner(java.lang.String value) {
		Object oldValue = this.joiner;
		this.joiner = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("joiner", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of occurrences of the attribute to map
	 */
	@ModelNodeBinding(detypedName = "maximum-segments")
	public Integer maximumSegments() {
		return this.maximumSegments;
	}

	/**
	 * The maximum number of occurrences of the attribute to map
	 */
	@SuppressWarnings("unchecked")
	public T maximumSegments(java.lang.Integer value) {
		Object oldValue = this.maximumSegments;
		this.maximumSegments = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maximumSegments", oldValue, value);
		return (T) this;
	}

	/**
	 * The OID of the X.500 attribute to map (can be defined using attribute
	 * name instead)
	 */
	@ModelNodeBinding(detypedName = "oid")
	public String oid() {
		return this.oid;
	}

	/**
	 * The OID of the X.500 attribute to map (can be defined using attribute
	 * name instead)
	 */
	@SuppressWarnings("unchecked")
	public T oid(java.lang.String value) {
		Object oldValue = this.oid;
		this.oid = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("oid", oldValue, value);
		return (T) this;
	}

	/**
	 * The attributes names of the attributes that must be present in the
	 * principal
	 */
	@ModelNodeBinding(detypedName = "required-attributes")
	public List<String> requiredAttributes() {
		return this.requiredAttributes;
	}

	/**
	 * The attributes names of the attributes that must be present in the
	 * principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredAttributes(java.util.List<String> value) {
		Object oldValue = this.requiredAttributes;
		this.requiredAttributes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requiredAttributes", oldValue, value);
		return (T) this;
	}

	/**
	 * The attributes names of the attributes that must be present in the
	 * principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredAttribute(String value) {
		if (this.requiredAttributes == null) {
			this.requiredAttributes = new java.util.ArrayList<>();
		}
		this.requiredAttributes.add(value);
		return (T) this;
	}

	/**
	 * The attributes names of the attributes that must be present in the
	 * principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredAttributes(String... args) {
		requiredAttributes(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The OIDs of the attributes that must be present in the principal
	 */
	@ModelNodeBinding(detypedName = "required-oids")
	public List<String> requiredOids() {
		return this.requiredOids;
	}

	/**
	 * The OIDs of the attributes that must be present in the principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredOids(java.util.List<String> value) {
		Object oldValue = this.requiredOids;
		this.requiredOids = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requiredOids", oldValue, value);
		return (T) this;
	}

	/**
	 * The OIDs of the attributes that must be present in the principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredOid(String value) {
		if (this.requiredOids == null) {
			this.requiredOids = new java.util.ArrayList<>();
		}
		this.requiredOids.add(value);
		return (T) this;
	}

	/**
	 * The OIDs of the attributes that must be present in the principal
	 */
	@SuppressWarnings("unchecked")
	public T requiredOids(String... args) {
		requiredOids(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * When set to 'true', the attribute values will be processed and returned
	 * in reverse order
	 */
	@ModelNodeBinding(detypedName = "reverse")
	public Boolean reverse() {
		return this.reverse;
	}

	/**
	 * When set to 'true', the attribute values will be processed and returned
	 * in reverse order
	 */
	@SuppressWarnings("unchecked")
	public T reverse(java.lang.Boolean value) {
		Object oldValue = this.reverse;
		this.reverse = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reverse", oldValue, value);
		return (T) this;
	}

	/**
	 * The 0-based starting occurrence of the attribute to map
	 */
	@ModelNodeBinding(detypedName = "start-segment")
	public Integer startSegment() {
		return this.startSegment;
	}

	/**
	 * The 0-based starting occurrence of the attribute to map
	 */
	@SuppressWarnings("unchecked")
	public T startSegment(java.lang.Integer value) {
		Object oldValue = this.startSegment;
		this.startSegment = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("startSegment", oldValue, value);
		return (T) this;
	}
}