package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.X500AttributePrincipalDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface X500AttributePrincipalDecoderConsumer<T extends X500AttributePrincipalDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of X500AttributePrincipalDecoder
	 * resource
	 * 
	 * @parameter Instance of X500AttributePrincipalDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default X500AttributePrincipalDecoderConsumer<T> andThen(
			X500AttributePrincipalDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}