package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configures a cache store as write-behind instead of write-through.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=custom/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=hotrod/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=file/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=remote/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=custom/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=hotrod/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=file/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=remote/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=custom/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=hotrod/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=file/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=remote/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=custom/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=hotrod/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=file/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=remote/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=custom/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=hotrod/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=binary-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=file/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=mixed-jdbc/write=behind",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/store=remote/write=behind"})
@ResourceType("write")
@Implicit
public class BehindWrite<T extends BehindWrite<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Timeout to acquire the lock which guards the state to be flushed to the cache store periodically.")
	private Long flushLockTimeout;
	@AttributeDocumentation("Maximum number of entries in the asynchronous queue. When the queue is full, the store becomes write-through until it can accept new entries.")
	private Integer modificationQueueSize;
	@AttributeDocumentation("Timeout in milliseconds to stop the cache store.")
	private Long shutdownTimeout;
	@AttributeDocumentation("Size of the thread pool whose threads are responsible for applying the modifications to the cache store.")
	private Integer threadPoolSize;

	public BehindWrite() {
		super();
		this.key = "behind";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Timeout to acquire the lock which guards the state to be flushed to the
	 * cache store periodically.
	 */
	@ModelNodeBinding(detypedName = "flush-lock-timeout")
	public Long flushLockTimeout() {
		return this.flushLockTimeout;
	}

	/**
	 * Timeout to acquire the lock which guards the state to be flushed to the
	 * cache store periodically.
	 */
	@SuppressWarnings("unchecked")
	public T flushLockTimeout(java.lang.Long value) {
		Object oldValue = this.flushLockTimeout;
		this.flushLockTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushLockTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is
	 * full, the store becomes write-through until it can accept new entries.
	 */
	@ModelNodeBinding(detypedName = "modification-queue-size")
	public Integer modificationQueueSize() {
		return this.modificationQueueSize;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is
	 * full, the store becomes write-through until it can accept new entries.
	 */
	@SuppressWarnings("unchecked")
	public T modificationQueueSize(java.lang.Integer value) {
		Object oldValue = this.modificationQueueSize;
		this.modificationQueueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("modificationQueueSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Timeout in milliseconds to stop the cache store.
	 */
	@ModelNodeBinding(detypedName = "shutdown-timeout")
	public Long shutdownTimeout() {
		return this.shutdownTimeout;
	}

	/**
	 * Timeout in milliseconds to stop the cache store.
	 */
	@SuppressWarnings("unchecked")
	public T shutdownTimeout(java.lang.Long value) {
		Object oldValue = this.shutdownTimeout;
		this.shutdownTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("shutdownTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the
	 * modifications to the cache store.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-size")
	public Integer threadPoolSize() {
		return this.threadPoolSize;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the
	 * modifications to the cache store.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolSize(java.lang.Integer value) {
		Object oldValue = this.threadPoolSize;
		this.threadPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolSize", oldValue, value);
		return (T) this;
	}
}