package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.infinispan.EvictionType;

/**
 * On-heap binary-based memory configuration.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/memory=binary",
		"/subsystem=infinispan/cache-container=*/local-cache=*/memory=binary",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/memory=binary",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/memory=binary",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/memory=binary"})
@ResourceType("memory")
@Implicit
public class BinaryMemory<T extends BinaryMemory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Indicates whether the size attribute refers to the number of cache entries (i.e. COUNT) or the collective size of the cache entries (i.e. MEMORY).")
	private EvictionType evictionType;
	@AttributeDocumentation("The number of cache eviction operations. May return null if the cache is not started.")
	private Long evictions;
	@AttributeDocumentation("Eviction threshold, as defined by the eviction-type.")
	private Long size;

	public BinaryMemory() {
		super();
		this.key = "binary";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates whether the size attribute refers to the number of cache
	 * entries (i.e. COUNT) or the collective size of the cache entries (i.e.
	 * MEMORY).
	 */
	@ModelNodeBinding(detypedName = "eviction-type")
	public EvictionType evictionType() {
		return this.evictionType;
	}

	/**
	 * Indicates whether the size attribute refers to the number of cache
	 * entries (i.e. COUNT) or the collective size of the cache entries (i.e.
	 * MEMORY).
	 */
	@SuppressWarnings("unchecked")
	public T evictionType(EvictionType value) {
		Object oldValue = this.evictionType;
		this.evictionType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evictionType", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "evictions")
	public Long evictions() {
		return this.evictions;
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T evictions(java.lang.Long value) {
		Object oldValue = this.evictions;
		this.evictions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evictions", oldValue, value);
		return (T) this;
	}

	/**
	 * Eviction threshold, as defined by the eviction-type.
	 */
	@ModelNodeBinding(detypedName = "size")
	public Long size() {
		return this.size;
	}

	/**
	 * Eviction threshold, as defined by the eviction-type.
	 */
	@SuppressWarnings("unchecked")
	public T size(java.lang.Long value) {
		Object oldValue = this.size;
		this.size = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("size", oldValue, value);
		return (T) this;
	}
}