package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.InvalidationCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface InvalidationCacheConsumer<T extends InvalidationCache<T>> {

	/**
	 * Configure a pre-constructed instance of InvalidationCache resource
	 * 
	 * @parameter Instance of InvalidationCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default InvalidationCacheConsumer<T> andThen(
			InvalidationCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}