package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.LockingComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LockingComponentConsumer<T extends LockingComponent<T>> {

	/**
	 * Configure a pre-constructed instance of LockingComponent resource
	 * 
	 * @parameter Instance of LockingComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default LockingComponentConsumer<T> andThen(
			LockingComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}