package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MixedJDBCStoreConsumer<T extends MixedJDBCStore<T>> {

	/**
	 * Configure a pre-constructed instance of MixedJDBCStore resource
	 * 
	 * @parameter Instance of MixedJDBCStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default MixedJDBCStoreConsumer<T> andThen(MixedJDBCStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}