package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * On-heap object-based memory configuration.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/local-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/memory=object"})
@ResourceType("memory")
@Implicit
public class ObjectMemory<T extends ObjectMemory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The number of cache eviction operations. May return null if the cache is not started.")
	private Long evictions;
	@AttributeDocumentation("Triggers eviction of the least recently used entries when the number of cache entries exceeds this threshold.")
	private Long size;

	public ObjectMemory() {
		super();
		this.key = "object";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "evictions")
	public Long evictions() {
		return this.evictions;
	}

	/**
	 * The number of cache eviction operations. May return null if the cache is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T evictions(java.lang.Long value) {
		Object oldValue = this.evictions;
		this.evictions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evictions", oldValue, value);
		return (T) this;
	}

	/**
	 * Triggers eviction of the least recently used entries when the number of
	 * cache entries exceeds this threshold.
	 */
	@ModelNodeBinding(detypedName = "size")
	public Long size() {
		return this.size;
	}

	/**
	 * Triggers eviction of the least recently used entries when the number of
	 * cache entries exceeds this threshold.
	 */
	@SuppressWarnings("unchecked")
	public T size(java.lang.Long value) {
		Object oldValue = this.size;
		this.size = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("size", oldValue, value);
		return (T) this;
	}
}