package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ObjectMemory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ObjectMemoryConsumer<T extends ObjectMemory<T>> {

	/**
	 * Configure a pre-constructed instance of ObjectMemory resource
	 * 
	 * @parameter Instance of ObjectMemory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ObjectMemoryConsumer<T> andThen(ObjectMemoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}