package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.OffHeapMemory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface OffHeapMemoryConsumer<T extends OffHeapMemory<T>> {

	/**
	 * Configure a pre-constructed instance of OffHeapMemory resource
	 * 
	 * @parameter Instance of OffHeapMemory to configure
	 * @return nothing
	 */
	void accept(T value);

	default OffHeapMemoryConsumer<T> andThen(OffHeapMemoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}