package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The cache transaction configuration.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=transaction",
		"/subsystem=infinispan/cache-container=*/local-cache=*/component=transaction",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=transaction",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=transaction",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/component=transaction"})
@ResourceType("component")
@Implicit
public class TransactionComponent<T extends TransactionComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The number of transaction commits. May return null if the cache is not started.")
	private Long commits;
	@AttributeDocumentation("The locking mode for this cache, one of OPTIMISTIC or PESSIMISTIC.")
	private Locking locking;
	@AttributeDocumentation("Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA, FULL_XA.")
	private Mode mode;
	@AttributeDocumentation("The number of transaction prepares. May return null if the cache is not started.")
	private Long prepares;
	@AttributeDocumentation("The number of transaction rollbacks. May return null if the cache is not started.")
	private Long rollbacks;
	@AttributeDocumentation("If there are any ongoing transactions when a cache is stopped, Infinispan waits for ongoing remote and local transactions to finish. The amount of time to wait for is defined by the cache stop timeout.")
	private Long stopTimeout;

	public TransactionComponent() {
		super();
		this.key = "transaction";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Locking {
		OPTIMISTIC("OPTIMISTIC"), PESSIMISTIC("PESSIMISTIC");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Locking(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Mode {
		NONE("NONE"), BATCH("BATCH"), NON_XA("NON_XA"), NON_DURABLE_XA(
				"NON_DURABLE_XA"), FULL_XA("FULL_XA");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Mode(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The number of transaction commits. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "commits")
	public Long commits() {
		return this.commits;
	}

	/**
	 * The number of transaction commits. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T commits(java.lang.Long value) {
		Object oldValue = this.commits;
		this.commits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("commits", oldValue, value);
		return (T) this;
	}

	/**
	 * The locking mode for this cache, one of OPTIMISTIC or PESSIMISTIC.
	 */
	@ModelNodeBinding(detypedName = "locking")
	public Locking locking() {
		return this.locking;
	}

	/**
	 * The locking mode for this cache, one of OPTIMISTIC or PESSIMISTIC.
	 */
	@SuppressWarnings("unchecked")
	public T locking(Locking value) {
		Object oldValue = this.locking;
		this.locking = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("locking", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA,
	 * FULL_XA.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public Mode mode() {
		return this.mode;
	}

	/**
	 * Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA,
	 * FULL_XA.
	 */
	@SuppressWarnings("unchecked")
	public T mode(Mode value) {
		Object oldValue = this.mode;
		this.mode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mode", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transaction prepares. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "prepares")
	public Long prepares() {
		return this.prepares;
	}

	/**
	 * The number of transaction prepares. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T prepares(java.lang.Long value) {
		Object oldValue = this.prepares;
		this.prepares = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("prepares", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transaction rollbacks. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "rollbacks")
	public Long rollbacks() {
		return this.rollbacks;
	}

	/**
	 * The number of transaction rollbacks. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T rollbacks(java.lang.Long value) {
		Object oldValue = this.rollbacks;
		this.rollbacks = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rollbacks", oldValue, value);
		return (T) this;
	}

	/**
	 * If there are any ongoing transactions when a cache is stopped, Infinispan
	 * waits for ongoing remote and local transactions to finish. The amount of
	 * time to wait for is defined by the cache stop timeout.
	 */
	@ModelNodeBinding(detypedName = "stop-timeout")
	public Long stopTimeout() {
		return this.stopTimeout;
	}

	/**
	 * If there are any ongoing transactions when a cache is stopped, Infinispan
	 * waits for ongoing remote and local transactions to finish. The amount of
	 * time to wait for is defined by the cache stop timeout.
	 */
	@SuppressWarnings("unchecked")
	public T stopTimeout(java.lang.Long value) {
		Object oldValue = this.stopTimeout;
		this.stopTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stopTimeout", oldValue, value);
		return (T) this;
	}
}