package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AsyncThreadPoolConsumer<T extends AsyncThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of AsyncThreadPool resource
	 * 
	 * @parameter Instance of AsyncThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default AsyncThreadPoolConsumer<T> andThen(AsyncThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}