package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * Configuration of the connection pool.
 */
@Address("/subsystem=infinispan/remote-cache-container=*/component=connection-pool")
@ResourceType("component")
@Implicit
public class ConnectionPoolComponent<T extends ConnectionPoolComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Specifies what happens when asking for a connection from a server's pool, and that pool is exhausted.")
	private ExhaustedAction exhaustedAction;
	@AttributeDocumentation("Controls the maximum number of connections per server that are allocated (checked out to client threads, or idle in the pool) at one time. When non-positive, there is no limit to the number of connections per server. When maxActive is reached, the connection pool for that server is said to be exhausted. Value -1 means no limit.")
	private Integer maxActive;
	@AttributeDocumentation("The amount of time in milliseconds to wait for a connection to become available when the exhausted action is ExhaustedAction.WAIT, after which a java.util.NoSuchElementException will be thrown. If a negative value is supplied, the pool will block indefinitely.")
	private Long maxWait;
	@AttributeDocumentation("Specifies the minimum amount of time that an connection may sit idle in the pool before it is eligible for eviction due to idle time. When non-positive, no connection will be dropped from the pool due to idle time alone. This setting has no effect unless timeBetweenEvictionRunsMillis > 0.")
	private Long minEvictableIdleTime;
	@AttributeDocumentation("Sets a target value for the minimum number of idle connections (per server) that should always be available. If this parameter is set to a positive number and timeBetweenEvictionRunsMillis > 0, each time the idle connection eviction thread runs, it will try to create enough idle instances so that there will be minIdle idle instances available for each server.")
	private Integer minIdle;

	public ConnectionPoolComponent() {
		super();
		this.key = "connection-pool";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum ExhaustedAction {
		EXCEPTION("EXCEPTION"), WAIT("WAIT"), CREATE_NEW("CREATE_NEW");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ExhaustedAction(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Specifies what happens when asking for a connection from a server's pool,
	 * and that pool is exhausted.
	 */
	@ModelNodeBinding(detypedName = "exhausted-action")
	public ExhaustedAction exhaustedAction() {
		return this.exhaustedAction;
	}

	/**
	 * Specifies what happens when asking for a connection from a server's pool,
	 * and that pool is exhausted.
	 */
	@SuppressWarnings("unchecked")
	public T exhaustedAction(ExhaustedAction value) {
		Object oldValue = this.exhaustedAction;
		this.exhaustedAction = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exhaustedAction", oldValue, value);
		return (T) this;
	}

	/**
	 * Controls the maximum number of connections per server that are allocated
	 * (checked out to client threads, or idle in the pool) at one time. When
	 * non-positive, there is no limit to the number of connections per server.
	 * When maxActive is reached, the connection pool for that server is said to
	 * be exhausted. Value -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "max-active")
	public Integer maxActive() {
		return this.maxActive;
	}

	/**
	 * Controls the maximum number of connections per server that are allocated
	 * (checked out to client threads, or idle in the pool) at one time. When
	 * non-positive, there is no limit to the number of connections per server.
	 * When maxActive is reached, the connection pool for that server is said to
	 * be exhausted. Value -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T maxActive(java.lang.Integer value) {
		Object oldValue = this.maxActive;
		this.maxActive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxActive", oldValue, value);
		return (T) this;
	}

	/**
	 * The amount of time in milliseconds to wait for a connection to become
	 * available when the exhausted action is ExhaustedAction.WAIT, after which
	 * a java.util.NoSuchElementException will be thrown. If a negative value is
	 * supplied, the pool will block indefinitely.
	 */
	@ModelNodeBinding(detypedName = "max-wait")
	public Long maxWait() {
		return this.maxWait;
	}

	/**
	 * The amount of time in milliseconds to wait for a connection to become
	 * available when the exhausted action is ExhaustedAction.WAIT, after which
	 * a java.util.NoSuchElementException will be thrown. If a negative value is
	 * supplied, the pool will block indefinitely.
	 */
	@SuppressWarnings("unchecked")
	public T maxWait(java.lang.Long value) {
		Object oldValue = this.maxWait;
		this.maxWait = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxWait", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the minimum amount of time that an connection may sit idle in
	 * the pool before it is eligible for eviction due to idle time. When
	 * non-positive, no connection will be dropped from the pool due to idle
	 * time alone. This setting has no effect unless
	 * timeBetweenEvictionRunsMillis > 0.
	 */
	@ModelNodeBinding(detypedName = "min-evictable-idle-time")
	public Long minEvictableIdleTime() {
		return this.minEvictableIdleTime;
	}

	/**
	 * Specifies the minimum amount of time that an connection may sit idle in
	 * the pool before it is eligible for eviction due to idle time. When
	 * non-positive, no connection will be dropped from the pool due to idle
	 * time alone. This setting has no effect unless
	 * timeBetweenEvictionRunsMillis > 0.
	 */
	@SuppressWarnings("unchecked")
	public T minEvictableIdleTime(java.lang.Long value) {
		Object oldValue = this.minEvictableIdleTime;
		this.minEvictableIdleTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minEvictableIdleTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets a target value for the minimum number of idle connections (per
	 * server) that should always be available. If this parameter is set to a
	 * positive number and timeBetweenEvictionRunsMillis > 0, each time the idle
	 * connection eviction thread runs, it will try to create enough idle
	 * instances so that there will be minIdle idle instances available for each
	 * server.
	 */
	@ModelNodeBinding(detypedName = "min-idle")
	public Integer minIdle() {
		return this.minIdle;
	}

	/**
	 * Sets a target value for the minimum number of idle connections (per
	 * server) that should always be available. If this parameter is set to a
	 * positive number and timeBetweenEvictionRunsMillis > 0, each time the idle
	 * connection eviction thread runs, it will try to create enough idle
	 * instances so that there will be minIdle idle instances available for each
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T minIdle(java.lang.Integer value) {
		Object oldValue = this.minIdle;
		this.minIdle = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minIdle", oldValue, value);
		return (T) this;
	}
}