package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface InvalidationNearCacheConsumer<T extends InvalidationNearCache<T>> {

	/**
	 * Configure a pre-constructed instance of InvalidationNearCache resource
	 * 
	 * @parameter Instance of InvalidationNearCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default InvalidationNearCacheConsumer<T> andThen(
			InvalidationNearCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}