package org.wildfly.swarm.config.infinispan.remote_cache_container;

import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface NoneNearCacheConsumer<T extends NoneNearCache<T>> {

	/**
	 * Configure a pre-constructed instance of NoneNearCache resource
	 * 
	 * @parameter Instance of NoneNearCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default NoneNearCacheConsumer<T> andThen(NoneNearCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}