package org.wildfly.swarm.config.io.worker;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Runtime resource that describes listening servers utilizing this worker
 */
@Address("/subsystem=io/worker=*/server=*")
@ResourceType("server")
public class Server<T extends Server<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Estimate of the current connection count")
	private Integer connectionCount;
	@AttributeDocumentation("If the connection count hits this number, no new connections will be accepted until the count drops below the low-water mark.")
	private Integer connectionLimitHighWaterMark;
	@AttributeDocumentation("If the connection count has previously hit the high water mark, once it drops back down below this count, connections will be accepted again.")
	private Integer connectionLimitLowWaterMark;

	public Server(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Estimate of the current connection count
	 */
	@ModelNodeBinding(detypedName = "connection-count")
	public Integer connectionCount() {
		return this.connectionCount;
	}

	/**
	 * Estimate of the current connection count
	 */
	@SuppressWarnings("unchecked")
	public T connectionCount(java.lang.Integer value) {
		Object oldValue = this.connectionCount;
		this.connectionCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionCount", oldValue, value);
		return (T) this;
	}

	/**
	 * If the connection count hits this number, no new connections will be
	 * accepted until the count drops below the low-water mark.
	 */
	@ModelNodeBinding(detypedName = "connection-limit-high-water-mark")
	public Integer connectionLimitHighWaterMark() {
		return this.connectionLimitHighWaterMark;
	}

	/**
	 * If the connection count hits this number, no new connections will be
	 * accepted until the count drops below the low-water mark.
	 */
	@SuppressWarnings("unchecked")
	public T connectionLimitHighWaterMark(java.lang.Integer value) {
		Object oldValue = this.connectionLimitHighWaterMark;
		this.connectionLimitHighWaterMark = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionLimitHighWaterMark",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If the connection count has previously hit the high water mark, once it
	 * drops back down below this count, connections will be accepted again.
	 */
	@ModelNodeBinding(detypedName = "connection-limit-low-water-mark")
	public Integer connectionLimitLowWaterMark() {
		return this.connectionLimitLowWaterMark;
	}

	/**
	 * If the connection count has previously hit the high water mark, once it
	 * drops back down below this count, connections will be accepted again.
	 */
	@SuppressWarnings("unchecked")
	public T connectionLimitLowWaterMark(java.lang.Integer value) {
		Object oldValue = this.connectionLimitLowWaterMark;
		this.connectionLimitLowWaterMark = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionLimitLowWaterMark",
					oldValue, value);
		return (T) this;
	}
}