package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.jca.Tracer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TracerConsumer<T extends Tracer<T>> {

	/**
	 * Configure a pre-constructed instance of Tracer resource
	 * 
	 * @parameter Instance of Tracer to configure
	 * @return nothing
	 */
	void accept(T value);

	default TracerConsumer<T> andThen(TracerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}