package org.wildfly.swarm.config.jgroups;

import org.wildfly.swarm.config.jgroups.Channel;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ChannelConsumer<T extends Channel<T>> {

	/**
	 * Configure a pre-constructed instance of Channel resource
	 * 
	 * @parameter Instance of Channel to configure
	 * @return nothing
	 */
	void accept(T value);

	default ChannelConsumer<T> andThen(ChannelConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}